/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class ListerSlots {
    private static Logger log = Logger.getLogger(ListerSlots.class);

    public static Resultat traitementP11(PKCS11 pKCS11, boolean bl) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo;
                block11: {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    resultatInfo = bl ? new ResultatInfo("Liste les slots avec carte (C_GetSlotList)") : new ResultatInfo("Liste tous les slots (C_GetSlotList)");
                    resultatInfo.setInfos(linkedHashMap);
                    try {
                        long[] lArray = pKCS11.C_GetSlotList(bl);
                        if (lArray != null) {
                            linkedHashMap.put("Nombre de slots", Integer.toString(lArray.length));
                            for (int i = 0; i < lArray.length; ++i) {
                                long l = lArray[i];
                                resultatInfo.getObjets().add(l);
                                linkedHashMap.put("Identifiant de slot" + (i + 1), Long.toString(l));
                            }
                            break block11;
                        }
                        log.error((Object)"La liste des slots retournee est nulle");
                        if (bl) {
                            throw new ExceptionTraitement(6, "La liste des slots retourn\u00e9e est nulle");
                        }
                        throw new ExceptionTraitement(5, "La liste des slots retourn\u00e9e est nulle");
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            if (bl) {
                throw new ExceptionTraitement(6, "La librairie est nulle");
            }
            throw new ExceptionTraitement(5, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            if (bl) {
                throw new ExceptionTraitement(6, "Une erreur inattendue est survenue");
            }
            throw new ExceptionTraitement(5, "Une erreur inattendue est survenue");
        }
    }
}

